	function [S1, S2] = L_PHASE_LATTICE_RICHARDS_HB(alfa, M, wT)

	% 	Computes the frequency response for the even and odd  
	%	branches in a half-band linear-phase lattice filter 
	%	with cascaded Richards' sections in parallel with M 
	%	delay elements. 
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2010-10-08
	% 	Modified by: 
	% 	Copyright:		by authors - not released for commercial use	
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to: Wanhammar@gmail.com

	ewT2 = exp(i*wT*2);
	ewT4 = exp(i*wT*4);
	N = length(alfa);
	% Odd branch
	S1 = -(1-alfa(1)*ewT2)./(ewT2-alfa(1));
	for k = 2:2:N-1
		a = alfa(k+1)*(1-alfa(k));
		S1 = -S1.*(-alfa(k)*ewT4-a*ewT2+1)./(ewT4-a*ewT2-alfa(k));
	end
	% Delay branch
%	S2 = unwrap(exp(-i*M*wT));
	S2 = exp(-i*M*wT);
